/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import filenet.vw.api.VWSession;
import filenet.vw.api.VWUserInfo;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.IVWAppLauncher;
import filenet.vw.toolkit.utils.IVWLaunchableApp;
import filenet.vw.toolkit.utils.VWChildAppManager;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.VWWindowAdapter;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.UIManager;

public abstract class VWBaseLaunchableApplication
extends JFrame
implements IVWLaunchableApp,
IVWAppLauncher {
    private VWChildAppManager m_childAppManager = null;
    private boolean m_bStandAlone = true;
    protected VWSessionInfo m_sessionInfo = null;
    protected String m_appSizeKey = null;
    protected String m_appPositionKey = null;

    public void init(VWSessionInfo sessionInfo) {
        try {
            this.m_sessionInfo = (VWSessionInfo)sessionInfo.clone();
            this.m_bStandAlone = this.m_sessionInfo.getParentContainer() == null;
            this.m_sessionInfo.setParentContainer(this);
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new VWWindowAdapter(this));
            if (System.getProperty("java.vm.version").startsWith("1.4.2")) {
                UIManager.getDefaults().put("MenuItemUI", "filenet.vw.toolkit.utils.VWWorkaroundMenuItemUI");
                UIManager.getDefaults().put("ClassLoader", this.m_sessionInfo.getExternalClassLoader());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void setSession(VWSession vwSession) {
    }

    public void windowClosing(WindowEvent event) {
        if (event == null) {
            return;
        }
        if (event.getSource() == this) {
            this.abort();
        } else {
            this.childWindowClosed();
        }
    }

    public void registerApplication(IVWLaunchableApp childApp) {
        try {
            if (this.m_childAppManager == null) {
                this.m_childAppManager = new VWChildAppManager(this);
            }
            this.m_childAppManager.registerApplication(childApp);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean hasChildClass(String className) {
        try {
            if (this.m_childAppManager == null) {
                return false;
            }
            return this.m_childAppManager.hasChildClass(className);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
    }

    public boolean bringChildAppToFront(String className) {
        try {
            if (this.m_childAppManager == null) {
                return false;
            }
            return this.m_childAppManager.bringChildAppToFront(className);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
    }

    protected void setFormattedWindowTitle(String windowTitle) {
        try {
            if (windowTitle == null) {
                windowTitle = VWResource.s_unknown;
            }
            this.setTitle(windowTitle);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void abort() {
        try {
            if (!this.destroy()) {
                return;
            }
            this.setVisible(false);
            this.dispose();
            if (this.m_bStandAlone) {
                System.exit(0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void childWindowClosed() {
    }

    protected boolean destroy() {
        this.savePosition(this.m_appPositionKey, this.m_appSizeKey);
        return this.logoff();
    }

    protected boolean hasChildren() {
        if (this.m_childAppManager != null) {
            return this.m_childAppManager.hasChildren();
        }
        return false;
    }

    protected boolean logoff() {
        boolean bAppsClosed = true;
        try {
            if (this.m_childAppManager != null) {
                bAppsClosed = this.m_childAppManager.closeChildApplications();
            }
            if (bAppsClosed && this.m_bStandAlone) {
                VWIDMBaseFactory.release();
                this.m_sessionInfo.logoff();
                this.m_sessionInfo = null;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return bAppsClosed;
    }

    protected void savePosition(String positionKey, String sizeKey) {
        VWUserInfo vwUserInfo = null;
        try {
            if (this.m_sessionInfo.getSession() != null) {
                vwUserInfo = this.m_sessionInfo.getSession().fetchCurrentUserInfo();
            }
            if (vwUserInfo != null) {
                if (positionKey != null && positionKey.length() > 0) {
                    Point location = this.getLocation();
                    String sPosition = VWStringUtils.dimensionToString(location.x, location.y);
                    vwUserInfo.setFieldValue(positionKey, sPosition);
                }
                if (sizeKey != null && sizeKey.length() > 0) {
                    String sSize = VWStringUtils.dimensionToString(this.getSize());
                    vwUserInfo.setFieldValue(sizeKey, sSize);
                }
                vwUserInfo.save();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    protected void updatePosition(int nAppWidth, int nAppHeight) {
        Point location;
        this.setSize(nAppWidth, nAppHeight);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension appSize = this.getSize();
        if (screenSize.width > appSize.width) {
            location = this.getLocation();
            this.setLocation((screenSize.width - appSize.width) / 2, location.y);
        }
        if (screenSize.height > appSize.height) {
            location = this.getLocation();
            this.setLocation(location.x, (screenSize.height - appSize.height) / 2);
        }
    }

    protected boolean updatePosition(String positionKey, String sizeKey) {
        VWUserInfo vwUserInfo = null;
        boolean bSuccessful = true;
        try {
            if (this.m_sessionInfo.getSession() != null) {
                vwUserInfo = this.m_sessionInfo.getSession().fetchCurrentUserInfo();
            }
        }
        catch (Exception ex) {
            return false;
        }
        if (vwUserInfo == null) {
            return false;
        }
        if (positionKey != null && positionKey.length() > 0) {
            try {
                Dimension position = VWStringUtils.stringToDimension((String)vwUserInfo.getFieldValue(positionKey));
                this.setLocation(position.width, position.height);
            }
            catch (Exception ex) {
                bSuccessful = false;
            }
            this.m_appPositionKey = positionKey;
        }
        if (sizeKey != null && sizeKey.length() > 0) {
            try {
                Dimension size = VWStringUtils.stringToDimension((String)vwUserInfo.getFieldValue(sizeKey));
                this.setSize(size);
            }
            catch (Exception ex) {
                bSuccessful = false;
            }
            this.m_appSizeKey = sizeKey;
        } else {
            this.setSize(640, 480);
        }
        return bSuccessful;
    }
}

